let marvelCharactersList = document.querySelector('.Marvel-Characters-list');
let marvelCharactersInfo = document.querySelector('.Marvel-Characters-info');
let previousButton = document.querySelector('.previousButton');
let nextButton = document.querySelector('.nextButton');
let nextLink, previousLink;


async function getData(offset) {
    let response = await fetch ('https://gateway.marvel.com/v1/public/characters?apikey=fdd61edff1037f76f2f547a814cd651d&offset=' + offset);
    let data = await response.json();
    nextLink = offset + 20;
    previousLink = offset - 20;
    if (offset > 0) {
        previousButton.disabled = false;
    } else {
        previousButton.disabled = true;
    }
    if (offset >= 1560) {
        nextButton.disabled = true;
    } else {
        nextButton.disabled = false;
    }
    console.log(data);
    marvelCharactersList.innerHTML = '';
    data.data.results.forEach((hero, index) => {
        
        marvelCharactersList.insertAdjacentHTML('beforeend', `
            <li><a href="#" data-x="${index}">${hero.name}</a></li>
        `)
    });

    let links = marvelCharactersList.querySelectorAll('a');
    links.forEach(link => {
        link.addEventListener('click', () => {
            let linkIndex = link.dataset.x;
            let hero = data.data.results[linkIndex];
            marvelCharactersInfo.innerHTML = `
                <h2>${hero.name}</h2>
                <img src="${hero.thumbnail.path}.${hero.thumbnail.extension}">
                <p>${hero.description}</p>
            `
        })
    })
    
}
getData(0);

nextButton.addEventListener('click', () => {
        getData(nextLink);
})

previousButton.addEventListener('click', () => {
        getData(previousLink);
})